
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;

public class ForestFire extends CAtoolbox {

	private static int norm(int n, int p) {
		return (n + p) % p;
	}

	private static void run(double densite) throws IOException {

		int dx = 50;
		int dy = 50;

		int[][] tableauCourant = new int[dx][dy];
		int[][] nouveauTableau = new int[dx][dy];

		int delai = 0;//100;

		int nombreDePasMaximum = 10000;//1000;
		int it = 0;

		// notre fichier
		DecimalFormat f = new DecimalFormat("0.00");
		FileWriter csv = new FileWriter("forest_"+f.format(densite)+".csv");
		csv.write("# it, nbArbresSains, nbArbresEnFeu\n");
		csv.flush();

		// les valeurs qu'on va utiliser pour compter
		int nbSains = 0;
		int nbArbresEnFeu = 0;

		// optionnel: initialise la visualisation dans une fenetre

		CAImageBuffer image = new CAImageBuffer(dx,dy);
		//ImageFrame imageFrame =	ImageFrame.makeFrame( "Forest fire", image, delai, 200, 200 );

		// on fait tourner l'automate

		//
		int nbTours = 1000;
		int[][][] stats = new int[nbTours][nombreDePasMaximum][2];

		for (int t = 0; t < nbTours; t++) {
			image = new CAImageBuffer(dx,dy);

			tableauCourant = new int[dx][dy];
			nouveauTableau = new int[dx][dy];

			it = 0;

			// initialisation (peuple la foret)
			for ( int x = 0 ; x != dx ; x++ )
				for ( int y = 0 ; y != dy ; y++ )
					if ( densite >= Math.random() )
						tableauCourant[(int)x][(int)y]=1; // tree

			tableauCourant[dx/2][dy/2] = 2; // burning tree

			do {
				// 1a - affiche de l'etat courant dans la fenetre graphique (toutes les cellules)
				image.updateForest(tableauCourant);

				// la ligne qu'on va
				String csvLigne = "" + it;
				nbSains = 0;
				nbArbresEnFeu = 0;

				// 1 - mise a jour de l'automate (dans le tableau en tampon)
				for (int x = 0; x != tableauCourant.length; x++)
					for (int y = 0; y != tableauCourant[0].length; y++) {
						// on compte le statut des arbres
						if (tableauCourant[x][y] == 1)
							stats[t][it][0]++;
						if (tableauCourant[x][y] == 2)
							stats[t][it][1]++;

						// par défaut on garde
						nouveauTableau[x][y] = tableauCourant[x][y];

						int gauche = 0, droite = 0, haut = 0, bas = 0;

						// on normalise x et y pour éviter des array out of bounds
						gauche = tableauCourant[norm(x - 1, tableauCourant.length)][y];
						droite = tableauCourant[norm(x + 1, tableauCourant.length)][y];
						haut = tableauCourant[x][norm(y - 1, tableauCourant[0].length)];
						bas = tableauCourant[x][norm(y + 1, tableauCourant[0].length)];

						// si on était déjà en feu, on devient
						if (tableauCourant[x][y] == 2)
							nouveauTableau[x][y] = 3;
						// vérifie si au moins un arbre voisin est en feu et si on est un arbre on peut prendre feu
						if ((gauche == 2 || droite == 2 || haut == 2 || bas == 2) && tableauCourant[x][y] == 1)
							nouveauTableau[x][y] = 2;
					}

				// 2 - met a jour le tableau affichable

				for (int x = 0; x != tableauCourant.length; x++)
					for (int y = 0; y != tableauCourant[0].length; y++)
						tableauCourant[x][y] = nouveauTableau[x][y];

				it++;

				// ne va pas trop vite...

				try {
					Thread.sleep(delai);
				} catch (InterruptedException e) {
				}
			} while (stats[t][it-1][1] != 0);
		}

		double[][] res = new double[nombreDePasMaximum][2];
		for (int i = 0; i < nombreDePasMaximum; i++) {
			for (int t = 0; t < nbTours; t++) {
				res[i][0] += stats[t][i][0];
				res[i][1] += (double)stats[t][i][0] / (double)stats[t][0][0];
				//res[i][1] += stats[t][i][1];
			}
			res[i][0] /= nbTours;
			res[i][1] /= nbTours;
			if (res[i][1] < 0.001)
				break;
			csv.write(i + "," + res[i][0] + "," + res[i][1] + "\n");
		}

		// et on ferme le fichier
		csv.flush();
		csv.close();
	}

	public static void main(String[] args) throws IOException {
		for (double i = 0.05; i < 1.00; i += 0.05) {
			run(i);
		}
		
	}

}
