
#include <stdint.h>
#include <string>
#include <sstream>
#include <iostream>
#include <algorithm>
#include <iterator>
#include <cstring>

#define P1 6
#define P2 13

#define BOARD_SIZE 14

#define int8 int_fast16_t
#define BOARD int8 b[BOARD_SIZE]
#define DEFAULT 4, 4, 4, 4, 4, 4, 0, 4, 4, 4, 4, 4, 4, 0

#define MAX_ITER 3

enum RESULT { UNEXPLORED, DONE, PLAY_AGAIN, CAPTURE, ROOT };

using namespace std;

int next_id = 0;

class Move {
public:
    Move* parent;
    int8 player;
    int8 layer;
    int8 move_pos;
    RESULT res;
    int id;
    BOARD;

    int8 number_of_next;
    Move* next[6];
    float score;
};

class MoveHelper {
    public:
        static Move* play(Move*);
        static Move* create_move(Move*, int8, int8);
        static void execute_move(Move*);
        static Move* init_game(Move*);
        static void print(Move*);
};

class BoardHelper {
    public:
        static void reset(BOARD);
        static void init(BOARD);
        static RESULT can_play_again(BOARD, int8, int8);
        static RESULT play(BOARD, int8, int8, RESULT);
        static int8 get_score(BOARD, int8);
        static void print(const BOARD);
};

ostream& operator<<(ostream &strm, const Move &m);
ostream& operator<<(ostream &strm, const int8* &b);

