extends Node3D

@onready var ball = $BallRigidBody
@onready var punch = $PunchStaticBody
@onready var perimeter = $PerimeterRigidBody

var rolling_force = 80
var angle = 0

# Called when the node enters the scene tree for the first time.
func _ready():
	pass # Replace with function body.


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	pass
	
func _physics_process(delta):
	var target_angle = angle
	if Input.is_action_pressed("forward"):
		ball.angular_velocity.x -= rolling_force*delta
		target_angle = PI
	elif Input.is_action_pressed("backward"):
		ball.angular_velocity.x += rolling_force*delta
		target_angle = 0
	if Input.is_action_pressed("leftward"):
		ball.angular_velocity.z += rolling_force*delta
		target_angle = 3*PI/2
	elif Input.is_action_pressed("rightward"):
		ball.angular_velocity.z -= rolling_force*delta
		target_angle = PI/2
	elif Input.is_action_pressed("punch"):
		pass
	
	angle += (target_angle - angle) * delta * 5
	var punch_position = Vector3(sin(angle), 0, cos(angle))
	
	punch.global_position = ball.global_position + punch_position
	
