import os, glob

vertices_file = "vertices.raw"
prefix = ""

directory = "parsed/"

def proc(filename, extract_type):
    print(f"Processing {filename} with extraction type {extract_type}")

    with open(filename, "rb") as in_f:
        in_data = in_f.read()
        out_data = []

        # extract vertices
        if extract_type == 'v':
            for i in range(0, len(in_data), 8):
                out_data += in_data[i:i+3]

        # extract texture coords
        if extract_type == 't':
            for i in range(0, len(in_data), 8):
                out_data += in_data[i:i+3]

        # extract indices
        if extract_type == 'i':
            #if len(in_data) % 3 == 0:
            if True:
                for i in range(0, len(in_data), 2):
                    out_data += in_data[i:i+2] + bytes([0, 0])
            else:
                print("ERROR: Got len(indices) % 3 != 0")
            #for i in range(0, len(in_data), 8):
            #    out_data.append(in_data[i:i+3])

        with open(prefix + filename[:-4] + ".txt", "wb") as out_f:
            bytea = bytes(out_data)
            out_f.write(bytea)
            out_f.close()

#proc("vertices", 'v')
#proc("indices", 'i')

files = glob.glob(directory + '*.raw')

for f in files:
    if "vertices" in f:
        proc(f, 'v')
    if "indices" in f:
        proc(f, 'i')
