#ifndef _BIBLIOH_H_
#define _BIBLIOH_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*--------------------------------Structures-------------------------------*/

typedef struct livreh {
    int clef;
    int num;
    char *titre;
    char *auteur;
    struct livreh *suiv;
} LivreH;

typedef struct table {
    int nE; /*nombre d'éléments contenus dans la table de hachage */
    int m; /*taille de la table de hachage */
    LivreH **T; /*table de hachage avec résolution des collisions par chainage */
} BiblioH;


/*--------------------------------Fonctions-------------------------------*/

/*--------------------------------Q.2.2------------------------------*/
int fonctionClef(char *auteur); //Associer une clef à un livre grâce à son auteur

/*--------------------------------Q.2.3-------------------------------*/
LivreH *creer_livre(int num, char *titre, char *auteur); // Création d'un livre.
void liberer_livre(LivreH *l); //Libération de l'espace pris en mémoire par LivreH.
BiblioH *creer_biblio(int m); // Création d'une bibliothèque
void liberer_biblio(BiblioH *b); //Libération de l'espace pris en mémoire par Biblio.

/*--------------------------------Q.2.4-------------------------------*/
int fonctionHachage(int cle, int m);

/*--------------------------------Q.2.5-------------------------------*/
void inserer(BiblioH *b, int num, char *titre, char *auteur); //Ajouter un nouveau livre en tête de notre bibliothèque.

/*--------------------------------Q.2.6------------------------------*/
void afficher_livre(LivreH *L); //Affichage d'un livre;
void afficher_biblio(BiblioH *b); //Affichage d'une bibliothèque
LivreH *recherche_num(BiblioH *b, int numero);//Rechercher un livre grâce à son numéro
LivreH *recherche_titre(BiblioH *b, char *t);//Rechercher un livre grâce à son titre
BiblioH *all_livres_auteur(BiblioH *b, char *a);//Retourne tous les livres du même auteur dans une nouvelle bibliothèque
void supprimer_livre(BiblioH *b, int n, char *t, char *a);//Suppression d'un livre
void fusion(BiblioH *b1, BiblioH *b2);//On fusionne deux bibliothèques et on supprime la deuxième
BiblioH *plusieurs_exemplaires(
        BiblioH *b);//Retourne une bibliothèque contenant les livres du même auteur ayant le même titre mais différents numéros
#endif