#include "libtests.h"
#include "biblioH.h"
#include "entreeSortieH.h"

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Genere un int aleatoirement entre valeurs
int genere_alea(int min, int max) {
    if (max < min) {
        printf("Warn, max demandé est plus petit que min (par défaut on utilise min)\n");
    }
    return (rand() % (max - min)) + min;
}

int main(int argc, char **argv) {
    srand(time(NULL));

    /*--------------------Conditions-d'exécution-du-main----------------------*/
    if (argc < 3) {
        printf("Erreur, veuillez respecter le format : ./mesureH nomfic nbLigne [nbEssaies] [tailleHashtable]\n");
        return 1;
    }

    /*--------------------Q-1.4.-Lecture-du-fichier----------------------*/
    char *fichier = argv[1];
    int nbLignes = atoi(argv[2]);
    int nbEssaies = 1;
    if (argc > 3)
        nbEssaies = atoi(argv[3]);
    int tailleHashtable = 300;
    if (argc > 4)
        tailleHashtable = atoi(argv[4]);

    BiblioH *B = charger_n_entrees(fichier, nbLignes, tailleHashtable);
    double valeurs[3] = {0,0,0};

    /*---------------------------Q.3.1---------------------*/
    INIT_CHRONO;

    int i;
    for (i = 0; i < nbEssaies; i++) {
        // Récupérer livre à index aléatoire
        int index = genere_alea(0, nbLignes);
        LivreH *l;

        /*----------------------Recherche par numéro---------------------*/
        START_CHRONO;
        l = recherche_num(B, index);
        FIN_CHRONO;
        valeurs[0] += temps_cpu;

        /*----------------------Recherche par titre---------------------*/
        START_CHRONO;
        recherche_titre(B, l->titre);
        FIN_CHRONO;
        valeurs[1] += temps_cpu;

        /*----------------------Recherche par auteur---------------------*/
        START_CHRONO;
        all_livres_auteur(B, l->auteur);
        FIN_CHRONO;
        valeurs[2] += temps_cpu;
    }

    // Affichage résultats
    printf("Résultats pour fichier=%s, nbLignes=%d, nbEssaies=%d, tailleTableau=%d\n", fichier, nbLignes, nbEssaies, tailleHashtable);
    printf("Temps moyen mis par recherche par numéro de table de hachage : %fs\n", valeurs[0] / nbEssaies);
    printf("Temps moyen mis par recherche par titre de table de hachage : %fs\n", valeurs[1] / nbEssaies);
    printf("Temps moyen mis par recherche par auteur de table de hachage : %fs\n", valeurs[2] / nbEssaies);
}