#include "biblioH.h"

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int fonctionClef(char *auteur) {
    int s = 0;
    unsigned long i;
    for (i = 0; i < strlen(auteur); i++) {  //On peut aussi faire un while(auteur[i]!= '\0') et incrémenter le i dans la boucle
        s = s + auteur[i];
    }
    return s;
}


LivreH *creer_livre(int num, char *titre, char *auteur) {
    //On réserve l'espace pour créer un livre.
    LivreH *livreh = (LivreH *) malloc(sizeof(LivreH));
    if (livreh == NULL) {
        printf("Erreur de malloc. \n");
        return 0;
    } else {
        livreh->clef = fonctionClef(auteur); //on utilise notre fonctionclef pour attribuer une clé au livre.
        livreh->num = num;
        livreh->titre = strdup(titre);
        livreh->auteur = strdup(auteur);
        livreh->suiv = NULL;
    }
    return livreh;
}


void liberer_livre(LivreH *l) {
    free(l->titre);
    free(l->auteur);
    free(l);
}

BiblioH *creer_biblio(int m) {
    //On réserve l'espace pour créer une bibliothèque.
    BiblioH *biblioh = (BiblioH *) malloc(sizeof(BiblioH));
    if (biblioh == NULL) {
        printf("Erreur de malloc. \n");
        return 0;
    } else {
        biblioh->nE = 0;
        biblioh->m = m;
        biblioh->T = (LivreH **) malloc(sizeof(LivreH) * m);
        for (int i = 0; i < m; i++) {
            biblioh->T[i] = NULL;
        }
    }
    return biblioh;
}

void liberer_biblio(BiblioH *b) {
    LivreH *courant, *tmp;
    for (int i = 0; i < b->m; i++) {
        courant = b->T[i];
        while (courant != NULL) {
            tmp = courant;
            courant = courant->suiv;
            liberer_livre(tmp);
        }
    }
    free(b->T);
    free(b);
}

int fonctionHachage(int cle, int m) {
    int A = (((sqrt(5) - 1) / 2));
    int f = (int) (m * ((cle * A) - floor(cle * A)));

    return f;
}

void inserer(BiblioH *b, int num, char *titre, char *auteur) {
    LivreH *new;
    new = creer_livre(num, titre, auteur);

    int hachage = fonctionHachage(new->clef, b->m);
    new->suiv = b->T[hachage];
    b->T[hachage] = new;
    b->nE++;
}

/*--------------------------------Q.2.6----------------------------*/
void afficher_livre(LivreH *L) {
    printf(" %d %s %s \n", L->num, L->titre, L->auteur);
}

void afficher_biblio(BiblioH *b) {//Affichage d'une bibliothèque
    if (b->nE == 0) {
        printf(" La bibliothèque est vide. \n");
        exit(0);
    }
    for (int i = 0; i < b->m; i++) {
        LivreH *livre = b->T[i];
        while (livre->suiv != NULL) {
            afficher_livre(livre);
            livre = livre->suiv;
        }
    }
}

LivreH *recherche_num(BiblioH *b, int numero) {
    int i = 0;
    LivreH *livre = b->T[i];
    for (i = 0; i < b->m; i++) {
        if (livre == NULL) {
            printf("Erreur, il n'y a pas de livre.\n");
        }
        while ((livre->num != numero) && (livre != NULL)) {
            livre = livre->suiv;
        }
    }
    return livre;
}

LivreH *recherche_titre(BiblioH *b, char *t) {
    int i = 0;
    LivreH *livre = b->T[i];
    for (i = 0; i < b->m; i++) {
        if (b == NULL) {
            printf("Erreur, il n'y a pas de bibliothèque.\n");
        }
        if (livre == NULL) {
            printf("Erreur, il n'y a pas de livre.\n");
        } else {
            while ((livre != NULL) && (strcmp(livre->titre, t) != 0)) {
                livre = livre->suiv;
            }
        }
    }
    return livre;
}

BiblioH *all_livres_auteur(BiblioH *b, char *a) {
    int i = 0;
    BiblioH *bi = creer_biblio(1);
    if (b == NULL || bi == NULL)
        printf("Erreur, il n'y a pas de bibliothèque.\n");

    LivreH *livre = b->T[i];
    for (i = 0; i < b->m; i++) {
        if (livre == NULL) {
            printf("Erreur, il n'y a pas de livre.\n");
        } else {
            while (livre->suiv != NULL) {
                if (strcmp(livre->auteur, a) == 0) {
                    inserer(bi, livre->num, livre->auteur, livre->titre);
                }
                livre = livre->suiv;
            }
        }
    }
    return bi;
}

void supprimer_livre(BiblioH *b, int n, char *t, char *a) {
    if (b->nE == 0) {
        printf("Warn, la bibliothèque est vide.\n");
    }
    int i;
    for (i = 0; i < b->m; i++) {
        LivreH *courant = b->T[i];
        if (courant != NULL) {
            if ((courant->num == n) && (courant->titre == t) && (courant->auteur == a)) {
                LivreH *suppr = courant;
                b->T[i] = suppr->suiv;
                free(suppr->titre);
                free(suppr->auteur);
                free(suppr);
                b->nE--;
            }

            while ((courant->suiv != NULL) && (courant->suiv->num != n) && (courant->titre != t) &&
                   (courant->auteur != a)) {
                courant = courant->suiv;
            }
            if (courant->suiv != NULL) {
                LivreH *suppr = courant;
                courant->suiv = suppr->suiv;
                free(suppr->titre);
                free(suppr->auteur);
                free(suppr);
                b->nE--;
            }
        }
    }
}


void fusion(BiblioH *b1, BiblioH *b2) {
    int i = 0;
    LivreH *l = b1->T[i];
    //Vérifier que b2 est valide
    if (b2 != NULL && b2->m > 0) {
        printf("Erreur, la deuxième bilio n'est pas valide.\n");
        exit(3);
    }

    for (i = 0; i < b1->m; i++) {
        int j;
        for (j = 0; j < b2->m; j++) {
            //On parcourt la bibliothèque jusqu'au dernier livre
            while (l->suiv != NULL) {
                l = l->suiv;
            }
            //On ajoute la deuxième bibliothèque après le dernier livre de la première
            l->suiv = b2->T[j];
            //On s'arrête au dernier livre de la deuxième bibliothèque
            b2->T[j] = NULL;
            //On libère l'espace pris par la deuxième bibliothèque
            free(b2);
        }
    }
}

BiblioH *plusieurs_exemplaires(BiblioH *b) {
    BiblioH *final = creer_biblio(b->m);
    for (int i = 0; i < b->m; i++) {
        LivreH *livre = b->T[i];
        while (livre != NULL) {
            LivreH *tmp = b->T[i];
            while (tmp != NULL) {
                if (strcmp(livre->titre, tmp->titre) == 0 && strcmp(livre->auteur, tmp->auteur) == 0 &&
                    livre->num != tmp->num && tmp != livre) {
                    inserer(final, tmp->num, tmp->titre, tmp->auteur);
                }
                tmp = tmp->suiv;
            }
            livre = livre->suiv;
        }
    }
    return final;
}	
