#include "biblioLC.h"

#include <stdio.h>
#include <stdlib.h>


Livre *creer_livre(int num, char *titre, char *auteur) {
    //On réserve l'espace pour créer un livre.
    Livre *l = (Livre *) malloc(sizeof(Livre));
    if (l == NULL) {
        printf("Erreur de malloc. \n");
        return 0;
    } else {
        l->num = num;
        l->titre = strdup(titre); // Pour réaliser une copie.
        l->auteur = strdup(auteur);
        l->suiv = NULL;
    }
    return l;
}

void liberer_livre(Livre *l) {
    free(l->titre);
    free(l->auteur);
    free(l);
}

Biblio *creer_biblio() {
    //On réserve l'espace pour créer une bibliothèque.
    Biblio *b = (Biblio *) malloc(sizeof(Biblio));
    //Cette bibliothèque est vide.
    b->L = NULL;
    return b;
}

void liberer_biblio(Biblio *b) {
    Livre *courant, *tmp;
    courant = b->L;
    while (courant != NULL) {
        tmp = courant;
        courant = courant->suiv;
        liberer_livre(tmp);
    }
    free(b);
}

void inserer_en_tete(Biblio *b, int num, char *titre, char *auteur) {
    Livre *newL = creer_livre(num, titre, auteur);
    newL->suiv = b->L;
    b->L = newL;
}

//Création d'une autre fonction inserer_en_tête plus facile d'utilisation
void inserer_en_tete2(Biblio *b, Livre *l) {
    l->suiv = b->L;
    b->L = l;
}

/*--------------------------------Q-1.6----------------------------*/

void afficher_livre(Livre *L) {
    printf("%d %s %s \n", L->num, L->titre, L->auteur);
}


void afficher_biblio(Biblio *b) {
    Livre *livre = b->L;
    while (livre != NULL) {
        afficher_livre(livre);
        livre = livre->suiv;
    }
}


Livre *recherche_num(Biblio *b, int numero) {
    if (b == NULL)
        printf("Erreur, il n'y a pas de bibliothèque.\n");
    if (b->L == NULL)
        printf("Erreur, il n'y a pas de livres.\n");

    Livre *livre = b->L;
    int went = 0;
    while (livre->suiv != NULL && livre->num != numero) {
        went++;
        livre = livre->suiv;
    }
    printf("went through %d\n", went);
    return livre;
}


Livre *recherche_titre(Biblio *b, char *t) {
    Livre *livre = b->L;
    if (b == NULL) {
        printf("Erreur, il n'y a pas de bibliothèque.\n");
    }
    if (livre == NULL) {
        printf("Erreur, il n'y a pas de livre.\n");
    }
    while ((strcmp(livre->titre, t) != 0) && (livre != NULL)) {
        livre = livre->suiv;
    }
    return livre;
}


Biblio *all_livres_auteur(Biblio *b, char *a) {
    Biblio *bi = creer_biblio();
    Livre *livre = b->L;
    while (livre != NULL) {
        if (strcmp(livre->auteur, a) == 0) {
            inserer_en_tete2(bi, livre);
        }
        livre = livre->suiv;
    }
    if (bi == NULL) {
        printf("La bibliothèque est vide : \n");
    } else {
        return bi;
    }
}


void supprimer_livre(Biblio *b, int n, char *t, char *a) {
    Livre *courant = b->L;
    Livre *tmp;
    while (courant->suiv != NULL) {
        tmp = courant->suiv;
        //Condition pour vérifier que le livre est bien celui que l'on désire supprimer
        if ((tmp->num == n) && (strcmp(tmp->titre, t) == 0) && (strcmp(tmp->auteur, a) == 0)) {
            courant = tmp->suiv;
            liberer_livre(tmp);
        }
        courant = courant->suiv;
    }
}


void fusion(Biblio *b1, Biblio *b2) {
    Livre *l = b1->L;
    //On parcourt la bibliothèque jusqu'au dernier livre
    while (l->suiv != NULL) {
        l = l->suiv;
    }
    //On ajoute la deuxième bibliothèque après le dernier livre de la première
    l->suiv = b2->L;
    //On s'arrête au dernier livre de la deuxième bibliothèque
    b2->L = NULL;
    //On libère l'espace pris par la deuxième bibliothèque
    free(b2);
}


Biblio *plusieurs_exemplaires(Biblio *b) {
    Biblio *p_e = creer_biblio();
    Livre *l = b->L;
    //D"abord on cherche tous les livres ayant le même auteur que l'on va mettre dans une bibliothèque
    while (l->suiv != NULL) {
        //On crée une bibliothèque ne contenant que les livres du même auteur
        Biblio *b1 = creer_biblio();
        b1 = all_livres_auteur(b, l->auteur);
        l = l->suiv;
        //Maintenant on vérifie les titres et les numéros
        Livre *l1 = b1->L;
        while (l1->suiv != NULL) {
            if (((strcmp(l->titre, l1->titre) == 0)) && (l->num != l1->num)) {
                //On ins_re le livre remplissant la condition dans notre bibliothèque résultat
                inserer_en_tete2(p_e, l1);
            }
            l1 = l1->suiv;
        }
        l = l->suiv;
    }
    return p_e;
}