
// petit header qui défini quelques macros pour faciliter le développement
#ifndef _LIBTESTS_H_
#define _LIBTESTS_H_

// pour ne pas se répéter autant en faisant les tests
#define INIT_CHRONO     clock_t temps_initial; double temps_cpu
#define START_CHRONO    temps_initial = clock()
#define FIN_CHRONO      temps_cpu = (double)(clock() - temps_initial) / CLOCKS_PER_SEC

// pour imprimer num de la question plus facilement
#define GRAS            "\033[1m"
#define NORM            "\033[0m"
#define PRINT_Q(S)      printf("%s---Question %s---%s\n\n", GRAS, (S), NORM)

// dans son shell, utiliser "export QUIET=1" pour désactiver l'affichage des données
// vous pouvez réactiver en faisant "unset QUIET"
int QUIET;

#endif
