#include "libtests.h"
#include "biblioLC.h"
#include "entreeSortieLC.h"

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Genere un int aleatoirement entre valeurs
int genere_alea(int min, int max) {
    if (max < min) {
        printf("Warn, max demandé est plus petit que min (par défaut on utilise min)\n");
    }
    return (rand() % (max - min)) + min;
}

int main(int argc, char **argv) {
    srand(time(NULL));

    /*--------------------Conditions-d'exécution-du-main----------------------*/
    if (argc < 3) {
        printf("Erreur, veuillez respecter le format : ./mesureLC nomfic nbLigne [nbEssaies]\n");
        return 1;
    }

    /*--------------------Q-1.4.-Lecture-du-fichier----------------------*/
    char *fichier = argv[1];
    int nbLignes = atoi(argv[2]);
    int nbEssaies = 1;
    if (argc > 3)
        nbEssaies = atoi(argv[3]);

    Biblio *B = charger_n_entrees(fichier, nbLignes);
    double valeurs[3] = {0,0,0};
    int *indexes = (int*)malloc(sizeof(int) * nbEssaies);

    /*---------------------------Q.3.1---------------------*/
    INIT_CHRONO;

    int i;

    for (i = 0; i < nbEssaies; i++) {
        indexes[i] = rand() % nbLignes;
    }

    for (i = 0; i < nbEssaies; i++) {
        // Récupérer livre à index aléatoire
        Livre *l;

        /*----------------------Recherche par numéro---------------------*/
        START_CHRONO;
        l = recherche_num(B, indexes[i]);
        FIN_CHRONO;
        valeurs[0] += temps_cpu;

        /*----------------------Recherche par titre---------------------*/
        START_CHRONO;
        recherche_titre(B, l->titre);
        FIN_CHRONO;
        valeurs[1] += temps_cpu;

        /*----------------------Recherche par auteur---------------------*/
        START_CHRONO;
        all_livres_auteur(B, l->auteur);
        FIN_CHRONO;
        valeurs[2] += temps_cpu;
    }

    // Affichage résultats
    printf("Résultats pour fichier=%s, nbLignes=%d, nbEssaies=%d\n", fichier, nbLignes, nbEssaies);
    printf("Temps moyen mis par recherche par numéro de liste chaînée : %fs\n", valeurs[0] / nbEssaies);
    printf("Temps moyen mis par recherche par titre de liste chaînée : %fs\n", valeurs[1] / nbEssaies);
    printf("Temps moyen mis par recherche par auteur de liste chaînée : %fs\n", valeurs[2] / nbEssaies);
}