# main.py
import asyncio
from metadata import read_tracks, metadata_loop
from stream import stream_loop

async def main():
    tracks = read_tracks()
    await asyncio.gather(
        metadata_loop(tracks),
        stream_loop()
    )

if __name__ == "__main__":
    asyncio.run(main())
