# stream.py
import asyncio
import requests
import os

M3U8_URL = "https://stream.radiofrance.fr/fip/fip_hifi.m3u8?id=radiofrance"
SEGMENT_FOLDER = "segments"

def fetch_m3u8():
    r = requests.get(M3U8_URL)
    if r.status_code != 200:
        print(f"[Stream] Failed to fetch m3u8: {r.status_code}")
        return {}

    lines = r.text.strip().splitlines()
    segment_map = {}

    current_time = None
    for line in lines:
        line = line.strip()
        if line.startswith("#EXT-X-PROGRAM-DATE-TIME:"):
            current_time = line.split(":", 1)[1]
        elif line and not line.startswith("#") and current_time:
            segment_map[current_time] = line
            current_time = None  # reset after pairing with a segment

    return segment_map

def download_segments(segment_map):
    print(f"TYpe: {type(segment_map)}")
    for (k, v) in segment_map.items():
        timestamp = k.replace(":", "_")
        print(f"Wanting to download: {timestamp} with url: {v}")

        target_segment_filename = SEGMENT_FOLDER + "/" + timestamp + ".ts"
        if os.path.exists(target_segment_filename):
            print(f"Skipping... {timestamp} already exists")
        else:
            r = requests.get("https://stream.radiofrance.fr" + v)
            if r.status_code == 200:
                with open(target_segment_filename, "wb") as f:
                    f.write(r.content)
                    f.close()
                    print(f"Wrote to {timestamp}")
            else:
                print(f"ERROR: Fetching song {v} failed with error code: {r.status_code}")


def setup_segment_folder():
    if not os.path.exists(SEGMENT_FOLDER):
        os.mkdir(SEGMENT_FOLDER)

async def stream_loop():
    setup_segment_folder()

    while True:
        segment_map = fetch_m3u8()
        if len(segment_map) > 0:
            download_segments(segment_map)

        await asyncio.sleep(4)
