extends Node3D
class_name Generator

@export var cols = Vector3i(245, 276, 239)
var facts = Vector3(1, 1, 1)
var pow_scaling = 0.4
var size = 1

var indices = Array()
var planes = Array()
var dims = Array()
var col_names
var song_ids = []
var song_values
var song_filenames
var lines = Array()

var fullscreen = false
var help_visible = true
var thread

var value_curve: ValuesCurve

@export var txt_url := "http://boite.trido.fr/liked_songs_results.txt"
@export var csv_filename := "res://songcache_additions.txt"#"my_tracklist_10k_ana_results.csv"
@export var texture_folder_path := "res://liked_songs_art"#"res://rating_10k_art"


func get_song_from_id(song_id):
	var index = song_ids.find(song_id)
	if index != -1:
		return song_filenames[index]

func parse_data(lines):
	#var file = FileAccess.open("res://my_tracklist_10k_ana_results.csv", FileAccess.READ)

	#var file = FileAccess.open(csv_filename, FileAccess.READ)
	#file.get_line()
	var song_ids = Array()
	var song_values = Array()
	var song_filenames = Array()
	
	var file_names = FileAccess.open("res://col_names.txt", FileAccess.READ)
	var col_names = file_names.get_as_text().split("\n")
	
	#while !file.():
	
	print("lines size: " + str(lines.size()))
	
	
	for li in range(lines.size()):
		var l = lines[li]
		if l.length() > 0:
			#print(l)
			var csv = l.split('\t')
			var song_id = csv[0].split(" ")[0].split("/")[-1]
			var song_filename = csv[0].split("/")[-1]
			var values = Array(csv.duplicate().slice(1))
			song_ids.append(song_id)
			song_filenames.append(song_filename)
			var vv = Array()
			for v in values:
				vv.append(float(v))

			song_values.append(vv)

	#file.close()
	var res = [song_ids, song_values, song_filenames, col_names]
	return res

func _on_request_completed(result, response_code, headers, body: PackedByteArray):
	if result != HTTPRequest.RESULT_SUCCESS:
		push_error("Song collection could not be loaded!")
	
	print("Received songcache!!")
	print("body size: " + str(body.size()))
	var file = body.get_string_from_utf8()
	lines = file.split("\n")
	
	var callable = Callable(self, "_thread_function")
	callable = callable.bindv([lines])
	thread = Thread.new()
	# Third argument is optional userdata, it can be any variable.
	thread.start(callable)
	#stream_length = stream.get_length()

func scale_coord(val):
	return Vector3((pow(val[0] * facts[0], pow_scaling) * 20) - 10, \
			(pow(val[1] * facts[1], pow_scaling) * 20) - 10, \
			(pow(val[2] * facts[2], pow_scaling) * 20) - 10)

func normalize_scene():	
	var raw_vals = [[], [], []]
	
	if planes.size() > 0:
		for index in range(planes.size()):
			var nindex = indices[index]
			raw_vals[0].append(song_values[nindex][cols[0]])
			raw_vals[1].append(song_values[nindex][cols[1]])
			raw_vals[2].append(song_values[nindex][cols[2]])
		
		var mins = Vector3(raw_vals[0].min(), raw_vals[1].min(), raw_vals[2].min())
		var maxs = Vector3(raw_vals[0].max(), raw_vals[1].max(), raw_vals[2].max())
		
		facts = Vector3(1, 1, 1) / (maxs - mins)
		
		#for index in range(planes.size()):
		#	var nindex = indices[index]
		#	planes[index].position = Vector3((song_values[nindex][cols[0]] * 20) - 10, (song_values[nindex][cols[1]] * 20) - 10, (song_values[nindex][cols[2]] * 20) - 10)

func refresh_label():
	$Info.text = str("scaling: " + str(pow_scaling) + "\nX: " + col_names[cols[0]] + "\nY: " + col_names[cols[1]] + "\nZ: " + col_names[cols[2]])

func update_scene(modif, force = false):
	if (modif[0] == 0 and modif[1] == 0 and modif[2] == 0) and force == false:
		return
	
	value_curve = get_parent().find_child("ValueCurves") as ValuesCurve
	
	cols += modif
	if value_curve:
		value_curve.refresh_windowed2(cols)
	print("cols: " + str(cols[0]) + ", " + str(cols[1]) + ", " + str(cols[2]))
	refresh_label()
	
	normalize_scene()
	
	for dim in range(dims.size()):
		dims[dim].text = str(cols[dim]) + "\n" + str(col_names[cols[dim]])
		
	for index in range(planes.size()):
		var nindex = indices[index]
		planes[index].position = scale_coord(Vector3(song_values[nindex][cols[0]], song_values[nindex][cols[1]], song_values[nindex][cols[2]]))

func update_scaling(diff):
	pow_scaling += diff

func update_size(diff):
	size += diff
	for index in range(planes.size()):
		var nindex = indices[index]
		planes[index].scale = Vector3(1, 1, 1) * size
	var player = get_parent().find_child("PlayerNode") as PlayerNode
	player.acceleration = size
	player.speed = size / 2


func _process(delta):
	var modif = Vector3i()
	
	if Input.is_action_just_pressed("inc_x"):
		modif[0] += 1
	if Input.is_action_just_pressed("dec_x"):
		modif[0] -= 1
	if Input.is_action_just_pressed("inc_y"):
		modif[1] += 1
	if Input.is_action_just_pressed("dec_y"):
		modif[1] -= 1
	if Input.is_action_just_pressed("inc_z"):
		modif[2] += 1
	if Input.is_action_just_pressed("dec_z"):
		modif[2] -= 1
		
	var should_update = false
	
	if Input.is_action_just_pressed("scale_up"):
		update_scaling(0.1)
		should_update = true
	if Input.is_action_just_pressed("scale_down"):
		update_scaling(-0.1)
		should_update = true
		
	if Input.is_action_just_pressed("size_up"):
		update_size(0.1)
	if Input.is_action_just_pressed("size_down"):
		update_size(-0.1)
	
	if Input.is_action_just_pressed("normalize") or should_update:
		#normalize_scene()
		update_scene(Vector3i(0, 0, 0), true)
	else:
		update_scene(modif)
		
	if Input.is_action_just_pressed("fullscreen"):
		fullscreen = !fullscreen
		toggle_fullscreen()
		
	if Input.is_action_just_pressed("help_wanted"):
		help_visible = !help_visible
		(get_parent_node_3d().find_child("HelpMenu") as Control).visible = help_visible
		

func toggle_fullscreen():
	if DisplayServer.window_get_mode() == DisplayServer.WINDOW_MODE_MAXIMIZED:
		DisplayServer.window_set_mode(DisplayServer.WINDOW_MODE_MAXIMIZED)
	else:
		DisplayServer.window_set_mode(DisplayServer.WINDOW_MODE_EXCLUSIVE_FULLSCREEN)
	var camera = (get_parent_node_3d().find_child("Player").find_child("Camera3D") as Camera3D)
	(camera.find_child("CrossUp") as MeshInstance2D).position = get_window().size / 2
	(camera.find_child("CrossDown") as MeshInstance2D).position = get_window().size / 2

func _ready():
	$HTTPRequest.request_completed.connect(_on_request_completed)
	$HTTPRequest.request(txt_url)
	
func _thread_function(lines):
	var res = parse_data(lines)
	song_ids = res[0]
	song_values = res[1]
	song_filenames = res[2]
	col_names = res[3]
	
	# Get the path to the folder containing the textures
	#var texture_folder_path := "res://songcache_art"
	#var texture_folder_path := "res://rating_10k_art"
	
	for i in range(0, 3):
		var dim = Label3D.new()
		dim.name = "col_" + str(i)
		dim.text = str(cols[i]) + "\n" + str(col_names[cols[i]])
		dim.position[(i+2)%3] -= 10
		dim.font_size = 256
		dims.append(dim)
		self.call_deferred("add_child", dim)
		
	dims[1].rotation[1] = PI/2#(i+1)%3
	dims[1].rotation[2] = -PI/2
	dims[2].rotation[0] = -PI/2#(i+1)%3
	dims[2].rotation[2] = PI/2#(i+1)%3
	
	dims[0].modulate = "ff4545"
	dims[1].modulate = "45ff45"
	dims[2].modulate = "4545ff"
	
	var filenames = Array()
	
	for f in song_filenames:
		if !((f as String).contains(".part")):
			filenames.append((f as String).replace(".m4a", "")+".jpg")
	
	for texture_path in filenames:#DirAccess.get_files_at(texture_folder_path):
		print(texture_path)
		var index = song_ids.find(texture_path.split(" ")[0])
		
		if texture_path.ends_with(".jpg") and index != -1:
			var texture_plane := MeshInstance3D.new()
			texture_plane.name = texture_path.split(" ")[0]
			texture_plane.mesh = QuadMesh.new()
			
			var texture := ResourceLoader.load(texture_folder_path + "/" + texture_path)
			var texture_material := StandardMaterial3D.new()

			texture_material.albedo_texture = texture
			texture_material.shading_mode = BaseMaterial3D.SHADING_MODE_UNSHADED
			#texture_material.fixed_size = true
			#texture_material.billboard_mode = BaseMaterial3D.BILLBOARD_ENABLED
			#texture_material.billboard_keep_scale = true
			#texture_material.billboard_mode = BaseMaterial3D.BILLBOARD_ENABLED

			texture_plane.mesh.surface_set_material(0, texture_material)
			print(texture_path.split(" ")[0])
			
			if index != -1:
				#print("FOUND INDEX")
				indices.append(index)
				texture_plane.position = scale_coord(Vector3(song_values[index][cols[0]], song_values[index][cols[1]], song_values[index][cols[2]]))
				texture_plane.call_deferred("create_convex_collision")
				planes.append(texture_plane)
				self.call_deferred("add_child", texture_plane)
			else:
				print("COULD NOT FIND INDEX")
				
			if self.planes.size() % 10 == 0:
				self.call_deferred("update_scene", Vector3i(0, 0, 0), true)
				
	
	#print("Could not find any textures")
	print("Planes len: " + str(self.planes.size()))
	
	

func _exit_tree():
	thread.wait_to_finish()
