extends Node3D
class_name PlayerNode

var speed = 0.5
var rotrate = 1

var move_dir: Vector2 # Input direction for movement
var look_dir: Vector2 # Input direction for look/aim

@export_range(2, 400, 1) var acceleration: float = 1 # m/s^2

var walk_vel: Vector3 # Walking velocity 
var mouse_captured: bool = false

var should_hit = false
const RAY_LENGTH = 1000

var cooldown = 0.1

@export var current_hit: MeshInstance3D
@export var info_hit: MeshInstance3D
@export_range(0.1, 9.25, 0.05, "or_greater") var camera_sens: float = 2

@onready var camera: Camera3D = $Camera3D

func _ready():
	pass

func _input(event):
	if event is InputEventMouseMotion: look_dir = event.relative * 0.05

func _physics_process(delta):
	if Input.is_key_pressed(KEY_SPACE):
		var space_state = get_world_3d().direct_space_state
		var to = global_position + camera.project_ray_normal(get_viewport().size / 2) * RAY_LENGTH
		var query = PhysicsRayQueryParameters3D.create(global_position, to)
		query.exclude = [self]
		var result = space_state.intersect_ray(query)
		
		var obj := (result.get("collider") as StaticBody3D)
		if obj:
			if obj.get_parent():
				var new_hit = obj.get_parent()
				if new_hit != current_hit:
					current_hit = new_hit
					get_parent().get_parent().find_child("MusicPlayer").load_song()
				print(obj.get_parent())
		else:
			current_hit = null
		
		#print(result)
		should_hit = false
	else:
		cooldown -= delta
		if cooldown < 0:
			cooldown += 0.2
			var space_state = get_world_3d().direct_space_state
			var to = global_position + camera.project_ray_normal(get_viewport().size / 2) * RAY_LENGTH
			var query = PhysicsRayQueryParameters3D.create(global_position, to)
			query.exclude = [self]
			var result = space_state.intersect_ray(query)
			
			var obj := (result.get("collider") as StaticBody3D)
			if obj:
				if obj.get_parent():
					var new_hit = obj.get_parent()
					if new_hit != info_hit:
						info_hit = new_hit
						get_parent().get_parent().find_child("MusicPlayer").load_temp_info()
					print(obj.get_parent())
			else:
				if info_hit:
					(get_parent().get_parent().find_child("InfoCard") as Label3D).visible = false
				info_hit = null
			
			#print(result)
			#should_hit = false
	
	if mouse_captured: _rotate_camera(delta)
	position += _walk(delta)
	
	
	
	if mouse_captured: _rotate_camera(delta)
	position += _walk(delta)

func capture_mouse() -> void:
	Input.set_mouse_mode(Input.MOUSE_MODE_CAPTURED)
	mouse_captured = true

func release_mouse() -> void:
	Input.set_mouse_mode(Input.MOUSE_MODE_VISIBLE)
	mouse_captured = false

func _walk(delta: float) -> Vector3:
	if !mouse_captured:
		capture_mouse()
	move_dir = Input.get_vector("move_left", "move_right", "move_forwards", "move_backwards")
	var up_down_dir = 1.0 if Input.is_key_pressed(KEY_E) else 0.0
	if Input.is_key_pressed(KEY_Q):
		up_down_dir = -1.0
	
	#move_dir = Input.get_vector(KEY_LEFT, "move_right", "move_forward", "move_backwards")
	var _forward: Vector3 = camera.transform.basis * Vector3(move_dir.x, up_down_dir, move_dir.y)
	var walk_dir: Vector3 = Vector3(_forward.x, _forward.y, _forward.z).normalized()
	walk_vel = walk_vel.move_toward(walk_dir * speed * move_dir.length(), acceleration * delta)
	return walk_vel

func _rotate_camera(delta: float, sens_mod: float = 1.0) -> void:
	look_dir += Input.get_vector("ui_left","ui_right","ui_up","ui_down")
	camera.rotation.y -= look_dir.x * camera_sens * sens_mod * delta
	camera.rotation.x = clamp(camera.rotation.x - look_dir.y * camera_sens * sens_mod * delta, -1.5, 1.5)
	look_dir = Vector2.ZERO
	
