extends AudioStreamPlayer3D
class_name MusicPlayer

var pending = false
var load_url = ""
var load_url_full = ""
var ana_url = ""
var info_url = ""
#@export var base_url := "http://localhost:10454/"
@export var base_url := "http://boite.trido.fr/"

var stream_progress = 0
var stream_length := 0.0

var round = 0

var full_stream := PackedByteArray()

@onready var value_curve = get_parent().find_child("ValueCurves") as ValuesCurve

@onready var sprite = get_parent().find_child("AlbumArt") as Sprite2D
@onready var large_album = get_parent().find_child("LargeAlbumArt") as MeshInstance3D
@onready var large_lyrics = get_parent().find_child("LargeLyrics") as Label3D
@onready var playing_info = get_parent().find_child("PlayingInfo") as Label
@onready var info_card = get_parent().find_child("InfoCard") as Label3D

@onready var progress_indicator = get_parent().find_child("ProgressIndicator") as Polygon2D

var streamIn: AudioStream
var audioBus: AudioEffectSpectrumAnalyzerInstance

var mag := Vector2.ZERO
var mag_lo := Vector2.ZERO
var mag_med := Vector2.ZERO
var mag_hi := Vector2.ZERO

var fact = 4

var shader_walls: ShaderMaterial
var shader_tess: ShaderMaterial

@export var now_playing: Dictionary
@export var selected_info: Dictionary

@onready var player_node = get_parent().find_child("Player").get_child(0) as PlayerNode
@onready var generator_node = get_parent().find_child("Generator") as Generator

var vals := Vector4(0.1, 0.1, 0.1, 0.1)

var current_info_filename := ""
var infos = Dictionary()

func _ready():
	$HTTPRequest.request_completed.connect(_on_request_completed)
	$HTTPRequest2.request_completed.connect(_on_request_completed2)
	$HTTPRequest3.request_completed.connect(_on_request_completed3)
	$HTTPRequest4.request_completed.connect(_on_request_completed4)
	$HTTPRequest5.request_completed.connect(_on_request_completed_info)
	audioBus = AudioServer.get_bus_effect_instance(0, 0) as AudioEffectSpectrumAnalyzerInstance
	print(AudioServer.get_input_device_list())
	var tess = get_parent().find_child("Tesseract") as MeshInstance3D
	shader_tess = (tess.get_surface_override_material(0) as ShaderMaterial)
	var walls = get_parent().find_child("Walls") as MeshInstance3D
	shader_walls = (walls.get_surface_override_material(0) as ShaderMaterial)
	#shader_walls = (large_album.get_surface_override_material(0) as ShaderMaterial)
	
	#$HTTPRequest.request("https://api.github.com/repos/godotengine/godot/releases/latest")

func _input(event):
	if Input.is_action_just_pressed("play_song"):
		load_song()
	if Input.is_action_just_pressed("escape"):
		get_tree().quit()
	if Input.is_action_just_pressed("sound"):
		if attenuation_model == AudioStreamPlayer3D.ATTENUATION_DISABLED:
			attenuation_model = AudioStreamPlayer3D.ATTENUATION_INVERSE_DISTANCE
			panning_strength = 0
		else:
			attenuation_model = AudioStreamPlayer3D.ATTENUATION_DISABLED
			panning_strength = 0.6

func load_temp_info():
	print("Loading temp info!")


	var song_filename
	if player_node.info_hit.name.is_valid_int():
		song_filename = generator_node.get_song_from_id(player_node.info_hit.name)
	
	if song_filename != current_info_filename and song_filename and ".part" not in song_filename:
		# force static song because of btrfsq
		#var load_url = base_url + "53 - Fred again - Marea (we’ve lost dancing).m4a".uri_encode()
		var card_url = base_url + "info/" + song_filename.uri_encode() + ".m4a"
		
		# update playing location and labels
		current_info_filename = song_filename + ".m4a"
		info_card.position = player_node.info_hit.position + Vector3(0.5, 0, 0)
		info_card.text = "\n".join(song_filename.split("-").slice(1))
		
		info_card.visible = true
		"""
		if infos.get(current_info_filename):
			self.selected_info = infos[current_info_filename]
			update_infocard()
			print("Got repeat!")
		else:
			# request the song
			print("got new info url: " + card_url)
			$HTTPRequest5.request(card_url)
		"""

func update_infocard():
	var s = selected_info["tags"]
	info_card.text = s["title"] + "\n" + s["album"] + "\n" + s["artist"] + "\n" + s["date"]
	info_card.visible = true
	
func update_lyrics():
	if self.now_playing:
		if self.now_playing.get("tags"):
			var s = now_playing["tags"]
			var l = s["lyrics"]
			large_lyrics.text = l
			large_lyrics.visible = true

func load_song():
	print("Loading song!")
	var player_node = get_parent().find_child("Player").get_child(0) as PlayerNode
	var generator_node = get_parent().find_child("Generator") as Generator

	var song_filename
	if player_node.current_hit:
		if player_node.current_hit.name.is_valid_int():
			song_filename = generator_node.get_song_from_id(player_node.current_hit.name)
	
	if !pending and song_filename:
		pending = true
		if self.playing:
			self.stop()
		
		# force static song because of btrfsq
		#var load_url = base_url + "53 - Fred again - Marea (we’ve lost dancing).m4a".uri_encode()
		var load_url = base_url + "preview/" + song_filename.uri_encode() + ".m4a"
		load_url_full = base_url + "full/" + song_filename.uri_encode() + ".m4a"
		ana_url = base_url + "tags/" + song_filename.uri_encode() + ".m4a"
		info_url = base_url + "info/" + song_filename.uri_encode() + ".m4a"
		
		# update playing location and labels
		position = player_node.current_hit.position
		sprite.texture = player_node.current_hit.mesh.surface_get_material(0).albedo_texture
		var album_mat = large_album.mesh.surface_get_material(0)
		album_mat.emission_texture = player_node.current_hit.mesh.surface_get_material(0).albedo_texture
		large_album.visible = true
		playing_info.text = "\n".join(song_filename.split("-").slice(1)).replace(".m4a", "")
		
		# request the song
		print("requesting: " + load_url)
		$HTTPRequest4.request(info_url)
		$HTTPRequest.request(load_url)
		

func _on_request_completed(result, response_code, headers, body):
	if result != HTTPRequest.RESULT_SUCCESS:
		push_error("Song couldn't be downloaded. Try a different song.")
	
	print("Received preview!!")
	#print("body size: " + str(body.size()))
	stream.data = body
	round = 0
	full_stream = PackedByteArray()
	#stream_length = stream.get_length()
	self.pending = false
	self.stream_progress = 0

	self.play()
	$HTTPRequest2.request(load_url_full)
	$HTTPRequest3.request(ana_url)
	
func _on_request_completed2(result, response_code, headers, body):
	if result != HTTPRequest.RESULT_SUCCESS:
		push_error("Song couldn't be downloaded. Try a different song.")
	
	print("Received rest of song!!")
	#print("body size: " + str(body.size()))
	
	var moment = self.get_playback_position()
	#self.stop()
	full_stream = body
	#stream_length = stream.get_length()
	#stream.instantiate_playback()

	if !self.playing:
		stream.data = full_stream
		self.play()
	
	#print(json["name"])
	
func _on_request_completed3(result, response_code, headers, body: PackedByteArray):
	if result != HTTPRequest.RESULT_SUCCESS:
		push_error("Song couldn't be analyzed. Try a different song.")
	
	print("Received song analysis!!")
	#print("body size: " + str(body.size()))
	var size = body.size()
	var windows = (size / 4) / 527
	
	var packed_values = body.to_float32_array()
	value_curve.load_windowed_song(packed_values)
	
func _on_request_completed4(result, response_code, headers, body: PackedByteArray):
	if result != HTTPRequest.RESULT_SUCCESS:
		push_error("Song info couldn't be fetched. Try a different song.")
	
	print("Received song info")
	#print("body size: " + str(body.size()))
	var json = JSON.parse_string(body.get_string_from_utf8())
	if json:
		self.now_playing = json["format"]
		stream_length = float(json["format"]["duration"])
		print("stream length: " + str(stream_length))
		update_lyrics()

func _on_request_completed_info(result, response_code, headers, body: PackedByteArray):
	if result != HTTPRequest.RESULT_SUCCESS:
		push_error("Song info couldn't be fetched. Try a different song.")
	
	print("Received song playcard")
	#print("body size: " + str(body.size()))
	var json = JSON.parse_string(body.get_string_from_utf8())
	if json:
		infos[json["format"]["filename"].split("/")[-1]] = json["format"]
		self.selected_info = json["format"]
		#var s = self.selected_info["tags"]
		update_infocard()
		#stream_length = float(json["format"]["duration"])
	

# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	if self.playing and stream_length != 0:
		self.stream_progress += delta
		progress_indicator.scale.x = self.stream_progress / stream_length
		
		# Called every frame. 'delta' is the elapsed time since the previous frame.
		mag_lo = audioBus.get_magnitude_for_frequency_range(20, 1000, 1) * fact
		mag_med = audioBus.get_magnitude_for_frequency_range(1000, 4000, 1) * fact
		mag_hi = audioBus.get_magnitude_for_frequency_range(4000, 15000, 1) * fact
		mag = audioBus.get_magnitude_for_frequency_range(0, 15000, 1) * fact
		
		var new_vals = Vector4((mag_lo[0] + mag_lo[1]) / 2.0, (mag_med[0] + mag_med[1]) / 2.0, (mag_hi[0] + mag_hi[1]) / 2.0, (mag[0] + mag[1]) / 2.0)
		vals = 0.2 * new_vals + 0.8 * vals
		shader_tess.set_shader_parameter("audio", vals)
		shader_walls.set_shader_parameter("audio", vals)
		#emission_energy_multiplier
		#print("shader param: " + str(shader.get_shader_parameter("audio")))
		large_album.transparency = 1 - ((mag_lo[0] + mag_lo[1]) / 2.0)
		
		#print("Mag: ", mag_lo)
	else:
		progress_indicator.scale.x = 0
		self.stream_progress = 0

func _on_finished():
	print("Called finished!")
	if round == 0 and self.stream.get_length() > 0:
		if full_stream.size() != 0:
			print("Switched inputs!")
			self.stream.data = full_stream
			#self.stream_progress += 20
			self.play()
			round = 1
	elif round == 1 and self.stream.get_length() > 0:
		print("value curve")
		full_stream = PackedByteArray()
		self.stream_progress = 0.0
		#value_curve.clear()
	else:
		large_album.visible = false
		large_lyrics.visible = false
		
	pass # Replace with function body.
