extends Node3D
class_name PlayerNode

var speed = 0.2
var rotrate = 1

var move_dir: Vector2 # Input direction for movement
var up_down_dir := 0.0
var look_dir: Vector2 # Input direction for look/aim

@export_range(1, 100, 0.1) var acceleration: float = 1 # m/s^2

var walk_vel: Vector3 # Walking velocity 
var mouse_captured: bool = false

var should_hit = false
const RAY_LENGTH = 1000

var cooldown = 0.1

@export var current_hit: MeshInstance3D
@export var info_hit: MeshInstance3D
@export_range(0.1, 9.25, 0.05, "or_greater") var camera_sens: float = 2

@onready var camera: Camera3D = $Camera3D

@onready var label = $Label
@onready var label2 = $Label2

@onready var finger1: Sprite2D = $Finger1
@onready var finger2: Sprite2D = $Finger2
@onready var finger3: Sprite2D = $Finger3

var fingers = Array()

# onready var label3 = $Label3
# onready var label4 = $Label4
# onready var label5 = $Label5

func _ready():
	fingers.append(finger1)
	fingers.append(finger2)
	fingers.append(finger3)
	pass

#func display_finger(which, x, y):
#	if which == 0:
#		finger1.visible = true
#		#finger1.position = 

func _input(event):
	if event is InputEventMouseMotion or event is InputEventSingleScreenDrag: look_dir = event.relative * 0.05

	#if event is InputEventAction and event.as_string() == ""
	if InputManager.real_raw and not event is InputEventMouseMotion and not event is InputEventKey:
		var a = event.as_string().replace('|','\n') 
		var b: RawGesture = InputManager.real_raw
		for i in range(b.drags.size()):
			if b.drags.values()[i]:
				var e = b.drags.values()[i]
				fingers[i].position = e.position
				if !fingers[i].visible:
					fingers[i].visible = true
				print("PRESSED!" + str(e.pressed))
		for i in range(b.releases.size()):
			if b.releases.values()[i]:
				var e = b.releases.values()[i]
				if fingers[i].visible:
					fingers[i].visible = false
				print("RELEASED!" + str(e.pressed))
		

	if (event is InputEventMultiScreenDrag or
		event is InputEventMultiScreenSwipe or
		event is InputEventMultiScreenTap or
		event is InputEventMultiScreenLongPress or
		event is InputEventSingleScreenDrag or
		event is InputEventScreenPinch or
		event is InputEventScreenTwist or
		event is InputEventSingleScreenTap or
		event is InputEventSingleScreenLongPress or
		event is InputEventSingleScreenTouch or
		event is InputEventSingleScreenSwipe or
		event is InputEventScreenCancel):
			label.text = event.as_string().replace('|','\n') 

	if event is InputEventMultiScreenDrag:
		if event.fingers == 2:
			up_down_dir += float(event.relative.y) / 2.0
			move_dir.x -= float(event.relative.x) / 2.0
			
		label2.text = "Multiple finger drag"
	elif event is InputEventMultiScreenSwipe:
		label2.text = "Multiple finger swipe"
	elif event is InputEventMultiScreenTap:
		label2.text = "Multiple finger tap"
	elif event is InputEventMultiScreenLongPress:
		label2.text = "Multiple finger long press"
	elif event is InputEventSingleScreenDrag: 
		label2.text = "Single finger drag"
	elif event is InputEventSingleScreenSwipe:
		label2.text = "Single finger swipe"
	elif event is InputEventScreenPinch:
		move_dir.y -= event.relative
		label2.text = "Pinch"
	elif event is InputEventScreenTwist:
		label2.text = "Twist"
	elif event is InputEventSingleScreenLongPress:
		var loc = Vector2(float(event.position.x) / float(get_viewport().size.x), float(event.position.y) / float(get_viewport().size.y))
		should_hit = true
		process_hit(loc.x, loc.y)
		label2.text = "Single finger long press\nloc: " + str(loc.x) + ", " + str(loc.y)
	elif event is InputEventSingleScreenTap:
		var loc = Vector2(float(event.position.x) / float(get_viewport().size.x), float(event.position.y) / float(get_viewport().size.y))
		should_hit = true
		process_hit(loc.x, loc.y)
		label2.text = "Single finger tap\nloc: " + str(loc.x) + ", " + str(loc.y)
		#label2.text = "Single finger tap"
	elif event is InputEventSingleScreenTouch:
		label2.text = "Single finger touch"
	elif event is InputEventScreenCancel:
		label2.text = "Cancel"

func process_hit(x, y):
	if should_hit:
		var loc = Vector2(x * float(get_viewport().size.x), y * float(get_viewport().size.y))
		var space_state = get_world_3d().direct_space_state
		var to = global_position + camera.project_ray_normal(loc) * RAY_LENGTH
		var query = PhysicsRayQueryParameters3D.create(global_position, to)
		query.exclude = [self]
		var result = space_state.intersect_ray(query)
		
		var obj := (result.get("collider") as StaticBody3D)
		if obj:
			if obj.get_parent():
				var new_hit = obj.get_parent()
				if new_hit != current_hit:
					current_hit = new_hit
					get_parent().get_parent().find_child("MusicPlayer").load_song()
				print(obj.get_parent())
		else:
			current_hit = null
	
	#print(result)
	should_hit = false

func _physics_process(delta):
	if Input.is_key_pressed(KEY_SPACE):
		should_hit = true
		process_hit(0.5, 0.5)
	else:
		cooldown -= delta
		if cooldown < 0:
			cooldown += 0.2
			var space_state = get_world_3d().direct_space_state
			var to = global_position + camera.project_ray_normal(get_viewport().size / 2) * RAY_LENGTH
			var query = PhysicsRayQueryParameters3D.create(global_position, to)
			query.exclude = [self]
			var result = space_state.intersect_ray(query)
			
			var obj := (result.get("collider") as StaticBody3D)
			if obj:
				if obj.get_parent():
					var new_hit = obj.get_parent()
					if new_hit != info_hit:
						info_hit = new_hit
						get_parent().get_parent().find_child("MusicPlayer").load_temp_info()
					print(obj.get_parent())
			else:
				if info_hit:
					(get_parent().get_parent().find_child("InfoCard") as Label3D).visible = false
				info_hit = null
			
			#print(result)
			#should_hit = false
	
	_rotate_camera(delta)
	position += _walk(delta)

func capture_mouse() -> void:
	Input.set_mouse_mode(Input.MOUSE_MODE_CAPTURED)
	mouse_captured = true

func release_mouse() -> void:
	Input.set_mouse_mode(Input.MOUSE_MODE_VISIBLE)
	mouse_captured = false

func _walk(delta: float) -> Vector3:
	if !mouse_captured:
		capture_mouse()
	move_dir += Input.get_vector("move_left", "move_right", "move_forwards", "move_backwards")
	#var up_down_dir = 1.0 if Input.is_key_pressed(KEY_E) else 0.0
	#if Input.is_key_pressed(KEY_Q):
	#	up_down_dir = -1.0
	
	#move_dir = Input.get_vector(KEY_LEFT, "move_right", "move_forward", "move_backwards")
	var _forward: Vector3 = camera.transform.basis * Vector3(move_dir.x, up_down_dir, move_dir.y)
	var walk_dir: Vector3 = Vector3(_forward.x, _forward.y, _forward.z).normalized()
	walk_vel = walk_vel.move_toward(walk_dir * speed * move_dir.length(), acceleration * delta)
	move_dir = Vector2(0, 0)
	up_down_dir = 0
	return walk_vel

func _rotate_camera(delta: float, sens_mod: float = 1.0) -> void:
	look_dir += Input.get_vector("ui_left","ui_right","ui_up","ui_down")
	camera.rotation.y -= look_dir.x * camera_sens * sens_mod * delta
	camera.rotation.x = clamp(camera.rotation.x - look_dir.y * camera_sens * sens_mod * delta, -1.5, 1.5)
	look_dir = Vector2.ZERO
	
