extends MeshInstance2D
class_name ValuesCurve

var xcurve: Curve

var filename_prefix := "res://windowed/windowed_ana_"
var filename: String

var cols: Vector3i
var target = 242

var col = 0

var song_values := Array()
var packed_values := PackedFloat32Array()
var windows = 100
var max = 0

func _ready():
	filename = filename_prefix + "5_2.5.csv"
	position.x = (get_viewport().size.x / 2) + 64
	#filename = "res://windowed_ana.csv"
	#load_windowed()
	
func _input(event):
	var e = event.as_text()
	if e.length() == 1 and e >= '1' and e <= '3':
		col = e[0].to_int() - 1
		refresh_windowed2()

func load_windowed_song(values: PackedFloat32Array):
	if !visible:
		visible = true
	max = 0
	packed_values = values
	
	windows = values.size() / 527
	
	mesh.sections = windows
	refresh_windowed2()

# Called when the node enters the scene tree for the first time.
func load_windowed():
	max = 0
	song_values = Array()
	
	var curve_file = FileAccess.open(filename, FileAccess.READ)
	
	while !curve_file.eof_reached():
		var values = curve_file.get_csv_line('\t')
		if values.size() > 1:
			var vv = Array()
			for v in values:
				vv.append(float(v))
			
			song_values.append(vv)

	mesh.sections = song_values.size()
	refresh_windowed()

func refresh_windowed2(new_cols=Vector3i()):
	if new_cols.length() > 1:
		self.cols = new_cols
	
	self.target = cols[col]
	if col == 0:
		modulate = "#99000099"
	if col == 1:
		modulate = "#00990099"
	if col == 2:
		modulate = "#00009999"
	
	max = 0
	
	if packed_values.size() > 0:
		for i in range(windows):
			if packed_values[i*527+target] > max:
				max = packed_values[i*527+target]
		
		xcurve = mesh.curve
		xcurve.clear_points()
		
		mesh.section_length = get_viewport().size.x / mesh.sections

		for i in range(windows):
			xcurve.add_point(Vector2(float(i)/float(windows), packed_values[i*527+target] / max))
		
		#self.mesh.generate_triangle_mesh()
		print("REFRESHED!!!")
		pass # Replace with function body.
	
func refresh_windowed(new_cols=Vector3i()):
	if new_cols.length() > 1:
		self.cols = new_cols
	
	self.target = cols[col]
	if col == 0:
		modulate = "#33000099"
	if col == 1:
		modulate = "#00330099"
	if col == 2:
		modulate = "#00003399"
	
	max = 0
	
	for i in range(song_values.size()):
		if song_values[i][target] > max:
			max = song_values[i][target]
	
	xcurve = mesh.curve
	xcurve.clear_points()
	
	var len = song_values.size()
	mesh.section_length = get_viewport().size.x / mesh.sections

	for i in range(len):
		xcurve.add_point(Vector2(float(i)/float(len), song_values[i][self.target] / max))
	
	#self.mesh.generate_triangle_mesh()
	#print(xcurve)
	pass # Replace with function body.


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	pass
