#!/bin/bash

# This file is part of the OpenKinect Project. http://www.openkinect.org
#
# Copyright (c) 2010 individual OpenKinect contributors. See the CONTRIB file
# for details.
#
# This code is licensed to you under the terms of the Apache License, version
# 2.0, or, at your option, the terms of the GNU General Public License,
# version 2.0. See the APACHE20 and GPL20 files for the text of the licenses,
# or the following URLs:
# http://www.apache.org/licenses/LICENSE-2.0
# http://www.gnu.org/licenses/gpl-2.0.txt
#
# If you redistribute this file in source form, modified or unmodified,
# you may:
# 1) Leave this header intact and distribute it under the same terms,
# accompanying it with the APACHE20 and GPL20 files, or
# 2) Delete the Apache 2.0 clause and accompany it with the GPL20 file, or
# 3) Delete the GPL v2.0 clause and accompany it with the APACHE20 file
# In all cases you must keep the copyright notice intact and include a copy
# of the CONTRIB file.
# Binary distributions must follow the binary distribution requirements of
# either License.

# fakenect wrapper script:
# simplifies calling libfreenect applications under fakenect
# by taking the fakenect database, app to run, and its args
# then filling out the necessary environment variables and calling the app
# usage: fakenect /path/to/fakenect/dump app --arg=value

# catch bad args
if [ $# -lt 2 ]
then
  echo "Usage: $0 <database> <application> <args>"
  exit -1
fi

# set path to fakenect database
export FAKENECT_PATH=$1

# set link path (LD_LIBRARY_PATH for Linux, DYLIB_LIBRARY_PATH for OS X)
if [ `uname` == "Darwin" ];
then
  export DYLD_LIBRARY_PATH="/usr/local/lib/fakenect/:${DYLD_LIBRARY_PATH}"
else
  export LD_LIBRARY_PATH="/usr/local/lib/fakenect/:${LD_LIBRARY_PATH}"
fi

# run desired app w/ args, now that environment is configured
"${@:2}"
