import json
import os
import sys
from selenium import webdriver
from selenium.webdriver.chrome.service import Service
from selenium.webdriver.common.by import By
from selenium.webdriver.support.ui import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC
from selenium.webdriver.common.keys import Keys
import threading
import time
from datetime import datetime, timedelta
import pytz

user_email = "noraaz@gwu.edu"
user_password = "ZhZh0808"

target_product = "40"

def read_cookies(cookie_filename):
    cookies_txt = []
    with open(cookie_filename, "r") as cook:
        cookies_txt = cook.readlines()
        cook.close()

    cookies = []
    for co in cookies_txt:
        if co.startswith("www.popmart"):
            c = co.split('\t')
            cookies.append((c[-2], c[-1][:-1]))

    return cookies

def add_cookies(cookies_filename):
    cookies = read_cookies(cookies_filename)

    driver.get("https://www.popmart.com/us")
    time.sleep(4)

    for c in cookies:
        print(f"Adding cookie name: {c[0]} and value {c[1]}")
        driver.add_cookie({'name':c[0], 'value':c[1]})

def add_localstorage(storage_filepath):
    local = ""
    with open(storage_filepath, "r") as l:
        local = l.read()
        l.close()

    local_storage_data = json.loads(local)
    for key, value in local_storage_data.items():
        driver.execute_script(f"localStorage.setItem({json.dumps(key)}, {json.dumps(value)});")

    print(f"Added {len(key)} local storage items")

def wait_for_elements(driver, by, value, retries=3, timeout=1):
    for i in range(retries):
        try:
            return WebDriverWait(driver, timeout).until(
                EC.presence_of_all_elements_located((by, value))
            )
        except Exception as e:
            if i < retries - 1:
                time.sleep(0.5)  # brief pause before retrying
                continue
            else:
                raise e

def get_product(product_num):
    driver.get("https://www.popmart.com/us/pop-now/set/{product_num}")

    boxes = wait_for_elements(driver, By.XPATH, '//img[contains(@class, "index_showBoxItem__5YQkR")]')

    print(f"Got {len(boxes)} boxes")

    for b in boxes:
        print("Trying box...")
        b.click()

def setup_webdriver():
    global driver, options, service
    # setup chromedriver
    service = Service("/usr/bin/chromedriver")
    options = webdriver.ChromeOptions()
    driver = webdriver.Chrome(service=service, options=options)

    driver.get(f'https://www.popmart.com/us/products')

    # setup cookies and localstorage
    add_cookies("cookies-popmart-com.txt")
    add_localstorage("localStorage_export.json")


setup_webdriver()
get_product(40)
