# Get environment paths
$env:ENV_HOME = python -c "import site; print(site.getsitepackages()[1])"
echo "env_home (site-packages): $env:ENV_HOME"
$env:CODE_HOME = (Get-Location).Path
echo "code_home: $env:CODE_HOME"

# Read build details
$buildDetails = Get-Content "build_details.txt"
$companyName = ($buildDetails[0] -split '\s+')[0]
$productName = ($buildDetails[1] -split '\s+')[0]
$fileVersion = ($buildDetails[2] -split '\s+')[0]
$productVersion = ($buildDetails[3] -split '\s+')[0]

echo "Company Name: $companyName"
echo "Product Name: $productName"
echo "File Version: $fileVersion"
echo "Product Version: $productVersion"

python -m nuitka Virtualize.py `
--mode=standalone `
--msvc=latest `
--enable-plugin=no-qt `
--module-parameter=torch-disable-jit=yes `
--windows-console-mode=disable `
--include-module=wx._xml `
--include-module=tensorly.backend.numpy_backend `
--include-module=tensorly.backend.pytorch_backend `
--include-module=tensorly.tenalg.core_tenalg `
--windows-icon-from-ico=$env:CODE_HOME/assets/Logos/VirtualizeIcon.ico `
--company-name=$companyName `
--product-name=$productName `
--file-version=$fileVersion `
--product-version=$productVersion `
--include-data-dir=$env:CODE_HOME/assets/=assets/ `
--include-data-dir=$env:CODE_HOME/checkpoints=checkpoints `
--include-data-dir=$env:ENV_HOME/viser/client=viser/client `
--include-data-dir=$env:ENV_HOME/viser/_icons=viser/_icons `
--include-data-dir=$env:ENV_HOME/panda3d/models/=models `
--include-data-files=$env:ENV_HOME/trimesh/resources/=trimesh/resources/=**/*.json `
--include-data-file=$env:CODE_HOME/modules/server/server-win.exe=./modules/server/server-win.exe `
--include-data-files=$env:ENV_HOME/torchmetrics/functional/image/lpips_models/=torchmetrics/functional/image/lpips_models/=**/*.pth
