import wx
import wx.adv
import multiprocessing



def show_splash():
  splash_app = wx.App(redirect=False)
  bitmap = wx.Bitmap("assets/Icons/splash.png", wx.BITMAP_TYPE_PNG)
  bitmap = bitmap.ConvertToImage().Rescale(bitmap.GetWidth()//2, bitmap.GetHeight()//2).ConvertToBitmap()
  # Show the splash screen. It will be closed automatically after 3000 ms
  splash = wx.adv.SplashScreen(bitmap, wx.adv.SPLASH_CENTRE_ON_SCREEN, 0, None, -1)
  splash.Show()
  return splash, splash_app

if __name__ == '__main__':
  
  splash, splash_app = show_splash()
  import sys
  import os
  import wx
  from modules.gui.frame_load import FrameLoad
    
  splash.Hide()
  splash.Destroy()
  splash_app.Destroy()

  multiprocessing.freeze_support()
  app = wx.App()

  frame = FrameLoad(parent=None)

  icon_path = "assets/Logos/Virtualize Icon.png"
  assets_path = "assets/"
  if getattr(sys, 'frozen', False):
    icon_path = "_internal/" + icon_path
    assets_path = "_internal/" + assets_path
  home_dir = os.path.expanduser("~")
  huggingface_cache_path = os.path.join(home_dir, '.cache', 'huggingface')

  if not os.path.exists(huggingface_cache_path):
    os.makedirs(huggingface_cache_path)
  # shutil.copytree(f"{assets_path}huggingface", huggingface_cache_path, dirs_exist_ok=True)

    
  frame.SetIcon(wx.Icon(icon_path, wx.BITMAP_TYPE_ANY))
  
  frame.Show()

  app.MainLoop()