import wx

class PanelDropDownArrow(wx.Panel):
  def __init__(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, name="DropDownArrow"):
    super().__init__(parent, id=id, pos=pos, size=size, style=style, name=name)
    sz = self.GetSize()
    self.collapsed_points = [wx.Point2D(5,5), wx.Point2D(sz.width-5, int(sz.height/2)), wx.Point2D(5, sz.height-5), wx.Point2D(5,5)]
    self.expanded_points = [wx.Point2D(5,5), wx.Point2D(sz.width-5, 5), wx.Point2D(int(sz.width/2), sz.height-5), wx.Point2D(5,5)]
    self.Bind(wx.EVT_PAINT, self.on_paint)

  def on_paint(self, event):
    dc = wx.PaintDC(self)
    gc = wx.GraphicsContext.Create(dc)

    gc.SetPen(wx.Pen(wx.Colour(100, 100, 100, alpha=wx.ALPHA_OPAQUE)))
    gc.SetBrush(wx.Brush(wx.Colour(144, 144, 144, alpha=wx.ALPHA_OPAQUE)))

    if self.GetGrandParent().is_expanded():
      gc.DrawLines(self.expanded_points)
    else:
      gc.DrawLines(self.collapsed_points)
