#include <iostream>
#include <fstream>
#include <stdio.h>
#include <eccodes.h>
#include <cmath>
#include <vector>

using namespace std;

#define MAX_FILENAME_LEN 256
#define MAX_STRING_LEN 256
#define ARRAY_SIZE 4

typedef struct {
    char filename[MAX_FILENAME_LEN];
    char strings[ARRAY_SIZE][MAX_STRING_LEN];
} FileStruct;

int dump_shortname_step(codes_index *ci, const char *name, const char *level, const char *step, const char *output_filename) {
    codes_handle* ch; int err;

    bool wind = strcmp(name, "wind") == 0;

    cout << "Got step: " << step << " and output " << output_filename << endl;

    // U component
    codes_index_select_string(ci, "shortName", wind ? "10u" : name);
    codes_index_select_string(ci, "step", step);

    ch = codes_handle_new_from_index(ci, &err);

    long num_lat = 1-1, num_lon = 0;

    codes_get_long(ch, "Ni", &num_lat);
    codes_get_long(ch, "Nj", &num_lon);

    cout << "\t(" << num_lat << ", " << num_lon << ")" << endl;

    size_t values_len = 0;
    CODES_CHECK(codes_get_size(ch,"values",&values_len),0);

    double *uvalues, *vvalues;
    uvalues = (double*)malloc(values_len*sizeof(double));

    codes_get_double_array(ch,"values",uvalues,&values_len);

    double min, max;
    // convert to 8 bit ints
    if (wind) {
        max = 26.0; min = -26.0;
    } else {
        codes_get_double(ch,"minimum",&min);
        codes_get_double(ch,"maximum",&max);
    }
    //min = 199.0, max = 326.0;
    min = 0.0; max = 1.0;
    cout << "Min: " << min << "\tMax: " << max << endl;

    double diff = max - min;

    codes_handle_delete(ch);

    // V component
    if (wind) {
        codes_index_select_string(ci, "shortName", "10v");
        codes_index_select_string(ci, "step", step);

        ch = codes_handle_new_from_index(ci, &err);

        vvalues = (double*)malloc(values_len*sizeof(double));

        codes_get_double_array(ch,"values",vvalues,&values_len);

        codes_handle_delete(ch);
    }

    // prepare final values
    u_int16_t* nvalues = (u_int16_t*)malloc(values_len*sizeof(u_int16_t));

    //u_int16_t* nvalues = (u_int16_t*)malloc(3*values_len*sizeof(u_int16_t));

    for (int i = 0; i < values_len; i++) {
        //nvalues[i] = 65536 * ((uvalues[i] - min) / diff);
        //values[i] *= (65536.0 / diff);
        //nvalues[i*3+0] = ((uvalues[i] + 25.0) / 50.0) * 65536.0;
        //nvalues[i*3+1] = ((vvalues[i] + 25.0) / 50.0) * 65536.0;

        // GOLD
        // nvalues[i] = (abs(atan2(vvalues[i], uvalues[i])) / 3.14159) * 65536.0;

        if (wind)
            nvalues[i] = (abs(atan2(vvalues[i], uvalues[i])) / 3.14159) * 65536.0;
        else
            nvalues[i] = 65536.0 * ((uvalues[i] - min) / diff);
    }

    // output to file
    FILE *output = fopen(output_filename, "w");

    fwrite(nvalues, 2, values_len, output);
    //fwrite(values, sizeof(double), values_len, output);
    fclose(output);

    free(uvalues);
    if (wind)
    free(vvalues);
    free(nvalues);

    return 0;
}

int dump_wind_dir(codes_index *ci, const char *step, const char *output_filename) {
    codes_handle* ch; int err;

    cout << "Got step: " << step << " and output " << output_filename << endl;

    // U component
    codes_index_select_string(ci, "shortName", "10u");
    codes_index_select_string(ci, "stepRange", step);

    ch = codes_handle_new_from_index(ci, &err);

    long num_lat = 1-1, num_lon = 0;

    codes_get_long(ch, "Ni", &num_lat);
    codes_get_long(ch, "Nj", &num_lon);

    cout << "\t(" << num_lat << ", " << num_lon << ")" << endl;

    size_t values_len = 0;
    CODES_CHECK(codes_get_size(ch,"values",&values_len),0);

    double* uvalues;
    uvalues = (double*)malloc(values_len*sizeof(double));

    codes_get_double_array(ch,"values",uvalues,&values_len);

    double min, max;
    // convert to 8 bit ints
    //codes_get_double(ch,"minimum",&min);
    //codes_get_double(ch,"maximum",&max);

    max = 26.0; min = -26.0;
    //cout << "Min: " << min << "\tMax: " << max << endl;

    double diff = max - min;

    codes_handle_delete(ch);

    // V component
    codes_index_select_string(ci, "shortName", "10v");
    codes_index_select_string(ci, "stepRange", step);

    ch = codes_handle_new_from_index(ci, &err);

    double* vvalues = (double*)malloc(values_len*sizeof(double));

    codes_get_double_array(ch,"values",vvalues,&values_len);

    codes_handle_delete(ch);

    // prepare final values
    u_int16_t* nvalues = (u_int16_t*)malloc(values_len*sizeof(u_int16_t));

    //u_int16_t* nvalues = (u_int16_t*)malloc(3*values_len*sizeof(u_int16_t));

    for (int i = 0; i < values_len; i++) {
        //values[i] -= min;
        //values[i] *= (65536.0 / diff);
        //nvalues[i*3+0] = ((uvalues[i] + 25.0) / 50.0) * 65536.0;
        //nvalues[i*3+1] = ((vvalues[i] + 25.0) / 50.0) * 65536.0;

        // GOLD
        // nvalues[i] = (abs(atan2(vvalues[i], uvalues[i])) / 3.14159) * 65536.0;

        nvalues[i] = (abs(atan2(vvalues[i], uvalues[i])) / 3.14159) * 65536.0;
    }

    // output to file
    FILE *output = fopen(output_filename, "w");

    fwrite(nvalues, 2, values_len, output);
    //fwrite(values, sizeof(double), values_len, output);
    fclose(output);

    free(uvalues);
    free(vvalues);
    free(nvalues);

    return 0;
}


int main(int argc, char **argv) {
    int err;
    codes_index *ci;

    const char *names = {"shortName,stepRange"};
    //const char *filename = "/dev/shm/W_fr-meteofrance,MODEL,AROME+001+HP1+00H_C_LFPW_202307061800--.grib2";
    //const char *filename = "/home/tristan/Downloads/hrrr.t00z.wrfsubhf01.grib2";
    //ci = codes_index_new_from_file(NULL, filename, names, &err);

    cout << "argc: " << argc << endl;

    // specify latest date and
    if (argc == 3) {
        cout << "Got filename: " << argv[1] << "     and name " << argv[2] << "!"  << endl;;
        ci = codes_index_new_from_file(NULL, argv[1], names, &err);

        char *filename = (char*)malloc(256);
        char *step = (char*)malloc(256);

        // extract the subhour's forecase
        char *time = (char*)malloc(3);
        memcpy(time, argv[1]+27, 2);
        time[2] = '\0';
        int realtime = atoi(time);

        if (realtime == 0) {
            snprintf(filename, MAX_STRING_LEN, "%s_name_%s_step_%04d.raw", argv[1], argv[2], 0);
            dump_shortname_step(ci, argv[2], "10", "0", filename);
        }
        else {
            for (int j = 0; j < 4; j++) {
                snprintf(step, MAX_STRING_LEN, "%d", realtime == 0 ? 0 : ((realtime-1)*60)+15);
                snprintf(filename, MAX_STRING_LEN, "%s_name_%s_step_%04d.raw", argv[1], argv[2], ((realtime-1)*60) + ((j+1)*15));
                dump_shortname_step(ci, argv[2], "10", step, filename);
            }
        }

        codes_index_delete(ci);
        exit(0);
    }
    // otherwise
    else {
        std::cout << "Run with ./weather-gen [filename] [shortName]" << endl;
    }

    return 0;
}

