extends Sprite2D
class_name CollectionBar

enum STATUS {
	UNLOADED = 0x7f000000,
	LOADED = 0x7fffffff,
	CAT_1 = 0xff00ffff,
	CAT_2 = 0x00ff00ff,
	CAT_3 = 0x0000ffff
}

var song_statuses: PackedInt32Array
var image: Image
var cat_width = 0

var window_width = 720

# Called when the node enters the scene tree for the first time.
func _ready():
	window_width = get_viewport_rect().size.x
	get_parent().size.x = window_width
	region_rect.size.x = window_width
	if image:
		update_texture()
	pass # Replace with function body.

func update_texture():
	self.image = Image.create_from_data(cat_width, 1, false, Image.FORMAT_RGBA8, self.song_statuses.to_byte_array())
	self.image.resize(window_width, 32, Image.INTERPOLATE_NEAREST)
	self.texture.update(self.image)

func init(width):
	self.song_statuses = PackedInt32Array()
	song_statuses.resize(width)
	cat_width = width
	song_statuses.fill(STATUS.UNLOADED)
	
	var new_texture = ImageTexture.new()
	self.image = Image.create_from_data(width, 1, false, Image.FORMAT_RGBA8, self.song_statuses.to_byte_array())

	self.image.resize(window_width, 32, Image.INTERPOLATE_NEAREST)
	self.texture = ImageTexture.create_from_image(self.image)
	print("used rect: " + str(self.image.get_used_rect()))
	#self.texture = new_texture
	#self.draw_texture(new_texture, Vector2(0, 0))

# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	pass
