extends Control

@onready var label := (find_child("RichTextLabel") as RichTextLabel)

func _ready():
	label.text = """GOAL

Move around and explore this music collection. Songs are analyzed into 520 different categories, 3 of which are plotted on the X, Y, and Z axes.

CONTROLS

"""
	
	if OS.get_name() == "iOS":
		label.text += """1 finger tap
	on album art - play song
	on cube walls - +1/-1 axis category 
	lower left screen corner - extra menu and settings
2 finger tap - toggle help menu
3 finger tap - load next batch of songs

1 or 2 finger swipe - look / navigate
2 finger pinch - zoom in and out



"""
	else:
		label.text += """Point at an album and press [space] to play. Press H to toggle this menu.
WASD: movement
U/J: +/- X axis (red)
I/K: +/- Y axis (green)
O/L: +/- Z axis (blue)
9/0: +/- album size
[space] - play selected song
[tab] - load next group
[backslash] - toggle lockscreen
1/2/3: switch segmented song analysis axis
F: fullscreens
H: help menu

"""
	label.text += """
Made by Tristan C
v0.6.0-rc1"""
	

func _input(event):
	if event is InputEventMultiScreenTap:
		if event.fingers == 2:
			# TODO PUT BACK
			#self.visible = !self.visible
			visible = false
			
	if event is InputEventSingleScreenTap:
		if self.visible:
			self.visible = false

