extends MeshInstance3D

@export var path3d_node_path: NodePath
var cooldown = 0

func _input(event):
	return
	if Input.is_key_label_pressed(KEY_2):
		if cooldown < 0:
			cooldown = 2
			build_path2()

func build_path2():
	var path3d = get_parent().get_child(0)
	var curve: Curve3D = path3d.curve
	var num_segments = 100
	var num_sides = 8
	var radius = 0.1

	var vertices = []
	var normals = []
	var uvs = []
	var indices = []

	for i in range(num_segments):
		var u = float(i) / num_segments
		var pos = curve.sample_baked(u)
		var tilt = curve.sample_baked_with_rotation(u)
		var normal = curve.sample_baked_up_vector(u)
		var binormal = normal.cross(Vector3.UP).normalized()

		for j in range(num_sides):
			var angle = (float(j) / num_sides) * 2 * PI
			var vertex_normal = (binormal * cos(angle) + normal.cross(binormal) * sin(angle)).normalized()
			var vertex_pos = pos + vertex_normal * radius * tilt
			var uv = Vector2(u, float(j) / num_sides)

			vertices.append(vertex_pos)
			normals.append(vertex_normal)
			uvs.append(uv)

	for i in range(num_segments - 1):
		for j in range(num_sides):
			indices.append((i * num_sides) + j)
			indices.append(((i + 1) % num_segments) * num_sides + j)
			indices.append((((i + 1) % num_segments) * num_sides) + ((j + 1) % num_sides))

			indices.append((i * num_sides) + j)
			indices.append((((i + 1) % num_segments) * num_sides) + ((j + 1) % num_sides))
			indices.append((i * num_sides) + ((j + 1) % num_sides))

	var mesh2 = ArrayMesh.new()
	var arrays = []
	arrays.resize(ArrayMesh.ARRAY_MAX)
	arrays[ArrayMesh.ARRAY_VERTEX] = vertices
	arrays[ArrayMesh.ARRAY_NORMAL] = normals
	arrays[ArrayMesh.ARRAY_TEX_UV] = uvs
	arrays[ArrayMesh.ARRAY_INDEX] = indices
	mesh2.add_surface_from_arrays(Mesh.PRIMITIVE_TRIANGLES, arrays)

	self.mesh = mesh2


func build_path():
	var path3d = get_parent().get_child(0)
	var curve: Curve3D = path3d.curve
	var mesh_data = SurfaceTool.new()
	var num_segments = 100
	var num_sides = 8
	var radius = 0.1
	
	mesh_data.begin(Mesh.PRIMITIVE_TRIANGLES)

	for i in range(num_segments):
		var u = float(i) / num_segments
		#curve.get_baked_points()
		var pos = curve.sample_baked(u)
		var tilt = curve.sample_baked_with_rotation(u)
		var normal = curve.sample_baked_up_vector(u)
		var binormal = normal.cross(Vector3.UP).normalized()

		for j in range(num_sides):
			var angle = (float(j) / num_sides) * 2 * PI
			var vertex_normal = (binormal * cos(angle) + normal.cross(binormal) * sin(angle)).normalized()
			var vertex_pos = pos + vertex_normal * radius * tilt
			var uv = Vector2(u, float(j) / num_sides)

			mesh_data.set_normal(vertex_normal)
			mesh_data.set_uv(uv)
			mesh_data.add_vertex(vertex_pos)
			#mesh_data.add_uv(uv)don'

	mesh_data.index()
	"""
	for i in range(num_segments - 1):
		for j in range(num_sides):
			var idx0 = i * num_sides + j
			var idx1 = i * num_sides + (j + 1) % num_sides
			var idx2 = (i + 1) * num_sides + j
			var idx3 = (i + 1) * num_sides + (j + 1) % num_sides

			mesh_data.add_index(idx0)
			mesh_data.add_index(idx1)
			mesh_data.add_index(idx2)
			mesh_data.add_index(idx1)
			mesh_data.add_index(idx3)
			mesh_data.add_index(idx2)
			#mesh_data.add_triangle_fan(PackedVector3Array(Array([idx0, idx1, idx2, idx1, idx3, idx2])))
			#mesh_data.add_triangle_fan()idx0, idx1, idx2)
			#mesh_data.add_triangle(idx1, idx3, idx2)
	"""
			
	for i in range(num_segments - 1):
		for j in range(num_sides):
			mesh_data.add_index(i * num_sides + j)
			mesh_data.add_index(((i + 1) % num_segments) * num_sides + j)
			mesh_data.add_index(((i + 1) % num_segments) * num_sides + (j + 1) % num_sides)
			mesh_data.add_index(i * num_sides + j)
			mesh_data.add_index(((i + 1) % num_segments) * num_sides + (j + 1) % num_sides)
			mesh_data.add_index(i * num_sides + (j + 1) % num_sides)

	var mesh = ArrayMesh.new()
	mesh_data.commit(mesh)
	self.mesh = mesh

# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	cooldown -= delta
