//
// Created by tristan on 1/3/21.
//

#include "board.h"
#include <stdio.h>

void reset(BOARD) {
    b[0] = 4, b[1] = 4, b[2] = 4, b[3] = 4, b[4] = 4, b[5] = 4, b[6] = 0;
    b[7] = 4, b[8] = 4, b[9] = 4, b[10] = 4, b[11] = 4, b[12] = 4, b[13] = 0;
}

void init(BOARD) {
    reset(b);
}

void create_queue(Move* new_move, Move* queue) {
    queue = malloc(sizeof(Move));
    queue->id = new_move->id;
    next_id++;
    queue->parent = new_move->parent;
    queue->player = new_move->player;
    queue->layer = new_move->layer;
    queue->move_pos = new_move->move_pos;
    memcpy(queue->b, new_move->b, BOARD_SIZE * sizeof(int8));
    queue->res = UNEXPLORED;
    queue->number_of_next = 0;
    queue->next = NULL;
}

Move* add_move(Move* new_move, Move* queue) {
    if (!queue->next) {
        //create_queue(new_move, queue);
        queue->next = new_move;
    }
    else {
        new_move->next = queue;
        queue = new_move;
    }
    return queue;
}

void create_move(Move* new_move, Move* m, int8 new_pos, int8 player) {
    new_move->id = next_id;
    next_id++;
    new_move->parent = m;
    new_move->player = player;
    new_move->layer = m->layer + 1;
    new_move->move_pos = new_pos;
    memcpy(new_move->b, m->b, BOARD_SIZE * sizeof(int8));
    new_move->res = UNEXPLORED;
    new_move->number_of_next = 0;
    new_move->next = NULL;
    //return new_move;
}

void execute_move(Move *m) {
    //print_move(m);
    // inits
    int8 offset = (m->player == P1) ? 0 : 7;
    int8 direction = (m->player == P1) ? 1 : -1;
    //int8 pos = offset + m->move_pos;

    int8 pos = m->move_pos;

    int8 beads = m->b[pos];
    m->b[pos] = 0;

    // add beads to corresponding holes
    for (int8 i = 0; i < beads; i++) {
        pos += 1;
        pos %= BOARD_SIZE;
        if (m->player == P1 && pos == P2)
            pos = 0;
        if (m->player == P2 && pos == P1)
            pos = P1 - 1;
        m->b[pos]++;
    }

    // check if can repeat for next move
    if (m->player == pos) {
        //printf("Could play again!!\n");
        m->res = PLAY_AGAIN;
    }
        // check if eligible for capture
    else if  ((m->b[pos] == 1 && pos != P1) && pos != P2) {
        if (m->player == P1 && pos < P1) {
            m->b[P1] += m->b[(P2 - 1) - pos];
            m->b[(P2 - 1) - pos] = 0;
            m->res = CAPTURE;
        }
        else if (m->player == P2 && pos > P1) {
            m->b[P2] += m->b[(P1 - 1) - (P2 - pos)];
            m->b[(P1 - 1) - (P2 - pos)] = 0;
            m->res = CAPTURE;
        }
    }
    else if (m->res == ROOT) {
        m->res = ROOT;
    }
    else
        m->res = DONE;
    //print_board(m->b);
}

Move* play(Move* m) {
    if ((m->res != ROOT && m->layer <= MAX_ITER))
        execute_move(m);

    int8 p = m->player;
    if (m->res == DONE || m->res == CAPTURE) {
        p = (p + 7) % BOARD_SIZE;
    }
    if (m->res == ROOT) {
        p = m->player;
    }

    int8 offset = (p == P1) ? 0 : 7;

    for (int i = offset; i < 6 + offset; i++) {
        if (m->b[i] >= 0) {
            m->number_of_next += 1;
            Move* new_move = (Move*)malloc(sizeof(Move));
            create_move(new_move, m, i, p);
            //printf("layer: %d, id: %ld\n", new_move->layer, new_move->id);
            if (!moves[new_move->layer]) {
                moves[new_move->layer] = malloc(sizeof(Move));
            }
            moves[new_move->layer] = add_move(new_move, moves[new_move->layer]);
        }
    }
}

Move* init_game() {
    int layer_tracker = 0;
    int i = 0;

    BOARD;
    Move* root = (Move*)malloc(sizeof(Move));
    root->player = P1;
    root->layer = 0;
    root->id = next_id;
    next_id++;
    init(root->b);
    root->res = ROOT;
    root->next = NULL;

    moves[0] = root;

    for (layer_tracker = 0; layer_tracker < MAX_ITER; layer_tracker++) {
        Move* current = moves[layer_tracker];
        do {
            if (current->id != 0) {
                play(current);
                if (current->b[P1] > record) {
                    record = current->b[P1];
                    print_move(current);
                    print_board(current->b);
                }
                current = current->next;
            }
            else
                current = current->next;
        } while (current);
    }

}

void print_move(Move *m) {
    printf("id: %ld\tP%c\tlayer: %d\tmove_pos: %d\n", m->id, ((m->player == P1) ? '1' : '2'), m->layer, m->move_pos);
}

RESULT can_play_again(Move *m, int8 move, int8 p) {
    if ((m->move_pos + m->b[m->move_pos]) % BOARD_SIZE == p) {
        return PLAY_AGAIN;
    }
    return CAPTURE;
}

int8 get_score(BOARD, int8 player) {
    return player == P1 ? b[P1] : b[P2];
}

void print_board(BOARD) {
    printf("   %d  %d  %d  %d  %d  %d\n", b[P2-1], b[P2-2], b[P2-3], b[P2-4], b[P2-5], b[P2-6]);
    printf(" %d                  %d\n", b[P2], b[P1]);
    printf("   %d  %d  %d  %d  %d  %d\n", b[0], b[1], b[2], b[2], b[3], b[4], b[5]);
}

int main(int argc, char *argv[]) {
    printf("%lu\n", sizeof(Move));
    init_game();
    return 0;
}
